﻿//////////////////////////////////////////////
// System.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class GamepadDeviceManager ;
	class InputSystem ;
	class KeyboardDeviceManager ;
	class LogManager ;
	class MouseDeviceManager ;
}

/// Includes ---------------------------------

// nkInputs
#include "Dll/DllDefines.h"

// Common
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

/// Class ------------------------------------

namespace nkInputs
{
	class DLL_INPUTS_EXPORT System final : public nkCommon::MaybeSingletonClass<System>
	{
		public :

			// Functions
			// Constructor, destructor
			System () noexcept ;
			virtual ~System () ;

			// Getters
			bool isInitialized () const ;
			InputSystem* getInputSystem () const ;
			GamepadDeviceManager* getGamepadDeviceManager () const ;
			KeyboardDeviceManager* getKeyboardDeviceManager () const ;
			LogManager* getLogManager () const ;
			MouseDeviceManager* getMouseDeviceManager () const ;

			// Lifetime
			bool initialize () ;
			void shutdown () ;

		private :

			// Functions
			// Constructors
			System (bool isSingleton) noexcept ;
			System (const System&) = delete ;
			System (System&&) = delete ;

			// Operators
			System& operator= (const System&) = delete ;
			System& operator= (System&&) = delete ;

		private :

			// Attributes
			// Internal created input system
			InputSystem* _inputSystem ;

			// Managers
			GamepadDeviceManager* _gamepadDeviceManager ;
			KeyboardDeviceManager* _keyboardDeviceManager ;
			LogManager* _logManager ;
			MouseDeviceManager* _mouseDeviceManager ;

		private :

			friend class nkCommon::MaybeSingletonClass<System> ;
	} ;
}